﻿//=============================================================================
// Alchemy.js
//=============================================================================

var Imported = Imported || {};
Imported.MoveCommand = true;

/*:
 * @plugindesc 錬金ウィンドウを表示するスクリプト
 */

(function ()
{
    // プラグイン コマンド
    var _Game_Interpreter_pluginCommand = Game_Interpreter.prototype.pluginCommand;
    Game_Interpreter.prototype.pluginCommand = function (command, args)
    {
        _Game_Interpreter_pluginCommand.call(this, command, args);

        if (command === 'Alchemy')
        {
            switch (args[0])
            {
                case 'show':
                    SceneManager.push(Scene_Alchemy);
                    break;

                case 'create':
                    // 錬金素材
                    for (var i = 121; i < 140;)
                    {
                        var id = $gameVariables.value(i);
                        if (id > 0)
                        {
                            var num = $gameVariables.value(i + 1);
                            $gameParty.gainItem($dataItems[id], -num)
                        }

                        i += 2;
                    }

                    // 生成物
                    $gameParty.gainItem($dataItems[$gameVariables.value(2)], 1);

                    // 錬金回数
                    $gameVariables.setValue(85, $gameVariables.value(85) + 1);
                    break;
            }
        }
    };

    //-----------------------------------------------------------------------------
    // AlchemyListWindow
    //
    // コンストラクタ
    function AlchemyListWindow()
    {
        this.initialize.apply(this, arguments);
    }

    AlchemyListWindow.prototype = Object.create(Window_Command.prototype);
    AlchemyListWindow.prototype.constructor = AlchemyListWindow;

    // プロパティ定義
    Object.defineProperties(AlchemyListWindow.prototype,
    {
        pageIndex: { get: function () { return this._pageIndex; }, },
        alchemyList: { get: function () { return this._alchemyList; } },
        requireWindow: { get: function () { return this._requireWindow; }, set: function (value) { this._requireWindow = value; } },
        canPlayOK: { get: function () { return this._canPlayOK; }, set: function (value) { this._canPlayOK = value; } },
    });

    // 初期化
    AlchemyListWindow.prototype.initialize = function ()
    {
        var x = 20;
        var y = 50;

        this._pageIndex = $gameVariables.value(9);
        this._maxPages = 1;
        this._alchemyList = [];

        Window_Command.prototype.initialize.call(this, x, y);

        this._requireWindow = null;
        this._canPlayOK = false;

        this.select($gameVariables.value(8));
    };

    AlchemyListWindow.prototype.index = function ()
    {
        if (this._index >= this._list[this._pageIndex].length)
        {
            this.select(this._list[this._pageIndex].length - 1);
        }

        return this._index;
    };

    AlchemyListWindow.prototype.maxItems = function ()
    {
        return this._list[this._pageIndex].length;
    };

    AlchemyListWindow.prototype.clearCommandList = function ()
    {
        this._list = [[], [], []];
    };

    AlchemyListWindow.prototype.addCommand = function (name, symbol, enabled, page, ext)
    {
        if (enabled === undefined)
        {
            enabled = true;
        }
        if (ext === undefined)
        {
            ext = null;
        }
        this._list[page].push({ name: name, symbol: symbol, enabled: enabled, ext: ext });
    };

    AlchemyListWindow.prototype.commandName = function (index)
    {
        return this._list[this._pageIndex][index].name;
    };

    AlchemyListWindow.prototype.commandSymbol = function (index)
    {
        return this._list[this._pageIndex][index].symbol;
    };

    AlchemyListWindow.prototype.isCommandEnabled = function (index)
    {
        return this._list[this._pageIndex][index].enabled;
    };

    AlchemyListWindow.prototype.currentData = function ()
    {
        return this.index() >= 0 ? this._list[this._pageIndex][this.index()] : null;
    };

    // 幅
    AlchemyListWindow.prototype.windowWidth = function ()
    {
        return 340;
    };

    // 決定音
    AlchemyListWindow.prototype.playOkSound = function ()
    {
        if (this._canPlayOK)
        {
            SoundManager.playOk();
        }
    };

    // コマンドの設定
    AlchemyListWindow.prototype.makeCommandList = function ()
    {
        var data;
        var list = [10, 100, 60, 70, 80, 90, 130, 140, 150, 160, 200, 170, 110, 120, 180, 190, 20, 30, 40, 50];
        var count, page;

        this._alchemyList = [];

        count = page = 0;
        for (var i = 0; i < list.length; ++i)
        {
            data = {};
            data.no = list[i];

            this.setAlchemyData(data);
            if (data.itemID != -1)
            {
                if ((count + 1) > 10)
                {
                    ++page;

                    count = 0;
                }
                else
                {
                    ++count;
                }

                this._alchemyList.push(data);
                this.addCommand($dataItems[data.itemID].name, 'alchemy_' + data.no, data.canAlchemy, page);
            }
        }

        this._maxPages = page + 1;
    };

    // 錬金可能かどうか
    AlchemyListWindow.prototype.setAlchemyData = function (data)
    {
        var numItems;

        switch (data.no)
        {
            // 大きな壺
            case 10:
                data.itemID = 129;

                data.materials = new Array(2);

                // 銅の鉱石 x2
                data.materials[0] = {};

                data.materials[0].itemID = 103;

                data.materials[0].requireNumItems = 2;
                numItems = $gameParty.numItems($dataItems[data.materials[0].itemID]);

                data.materials[0].hasNumItems = numItems >= data.materials[0].requireNumItems;

                // けものの皮 x1
                data.materials[1] = {};

                data.materials[1].itemID = 108;

                data.materials[1].requireNumItems = 1;
                numItems = $gameParty.numItems($dataItems[data.materials[1].itemID]);

                data.materials[1].hasNumItems = numItems >= data.materials[1].requireNumItems;
                break;
/*
            // ハイポーション
            case 10:
                data.itemID = 2;

                data.materials = new Array(1);

                // ポーション x2
                data.materials[0] = {};

                data.materials[0].itemID = 1;

                data.materials[0].requireNumItems = 2;
                numItems = $gameParty.numItems($dataItems[data.materials[0].itemID]);

                data.materials[0].hasNumItems = numItems >= data.materials[0].requireNumItems;
                break;
*/
            // つるはし
            case 60:
                data.itemID = 130;

                data.materials = new Array(2);

                // 鉄鉱石 x2
                data.materials[0] = {};

                data.materials[0].itemID = 104;

                data.materials[0].requireNumItems = 2;
                numItems = $gameParty.numItems($dataItems[data.materials[0].itemID]);

                data.materials[0].hasNumItems = numItems >= data.materials[0].requireNumItems;

                // じょうぶな枝 x1
                data.materials[1] = {};

                data.materials[1].itemID = 106;

                data.materials[1].requireNumItems = 1;
                numItems = $gameParty.numItems($dataItems[data.materials[1].itemID]);

                data.materials[1].hasNumItems = numItems >= data.materials[1].requireNumItems;
                break;
/*
            // デラックスポーション
            case 60:
                data.itemID = 6;

                data.materials = new Array(1);

                // ハイポーション x2
                data.materials[0] = {};

                data.materials[0].itemID = 2;

                data.materials[0].requireNumItems = 2;
                numItems = $gameParty.numItems($dataItems[data.materials[0].itemID]);

                data.materials[0].hasNumItems = numItems >= data.materials[0].requireNumItems;
                break;
*/
            // 鉄のクギ
            case 70:
                data.itemID = 131;

                data.materials = new Array(1);

                // 鉄鉱石 x2
                data.materials[0] = {};

                data.materials[0].itemID = 104;

                data.materials[0].requireNumItems = 2;
                numItems = $gameParty.numItems($dataItems[data.materials[0].itemID]);

                data.materials[0].hasNumItems = numItems >= data.materials[0].requireNumItems;
                break;
/*
            // エクストラポーション
            case 70:
                data.itemID = 9;

                data.materials = new Array(1);

                // デラックスポーション x2
                data.materials[0] = {};

                data.materials[0].itemID = 6;

                data.materials[0].requireNumItems = 2;
                numItems = $gameParty.numItems($dataItems[data.materials[0].itemID]);

                data.materials[0].hasNumItems = numItems >= data.materials[0].requireNumItems;
                break;
*/
            // 植物油
            case 80:
                data.itemID = 133;

                data.materials = new Array(1);

                // ブラシカの花 x5
                data.materials[0] = {};

                data.materials[0].itemID = 132;

                data.materials[0].requireNumItems = 5;
                numItems = $gameParty.numItems($dataItems[data.materials[0].itemID]);

                data.materials[0].hasNumItems = numItems >= data.materials[0].requireNumItems;
                break;
/*
            // 怪力の薬
            case 80:
                data.itemID = 3;

                data.materials = new Array(2);

                // 火炎草 x1
                data.materials[0] = {};

                data.materials[0].itemID = 109;

                data.materials[0].requireNumItems = 1;
                numItems = $gameParty.numItems($dataItems[data.materials[0].itemID]);

                data.materials[0].hasNumItems = numItems >= data.materials[0].requireNumItems;

                // 魔法の水 x1
                data.materials[1] = {};

                data.materials[1].itemID = 111;

                data.materials[1].requireNumItems = 1;
                numItems = $gameParty.numItems($dataItems[data.materials[1].itemID]);

                data.materials[1].hasNumItems = numItems >= data.materials[1].requireNumItems;
                break;
*/
            // じょうぶな紐
            case 90:
                data.itemID = 134;

                data.materials = new Array(2);

                // けものの皮 x1
                data.materials[0] = {};

                data.materials[0].itemID = 108;

                data.materials[0].requireNumItems = 1;
                numItems = $gameParty.numItems($dataItems[data.materials[0].itemID]);

                data.materials[0].hasNumItems = numItems >= data.materials[0].requireNumItems;

                // ブラシカの花 x3
                data.materials[1] = {};

                data.materials[1].itemID = 132;

                data.materials[1].requireNumItems = 3;
                numItems = $gameParty.numItems($dataItems[data.materials[1].itemID]);

                data.materials[1].hasNumItems = numItems >= data.materials[1].requireNumItems;
                break;
/*
            // 鉄壁の薬
            case 90:
                data.itemID = 4;

                data.materials = new Array(2);

                // 氷草 x1
                data.materials[0] = {};

                data.materials[0].itemID = 110;

                data.materials[0].requireNumItems = 1;
                numItems = $gameParty.numItems($dataItems[data.materials[0].itemID]);

                data.materials[0].hasNumItems = numItems >= data.materials[0].requireNumItems;

                // 魔法の水 x1
                data.materials[1] = {};

                data.materials[1].itemID = 111;

                data.materials[1].requireNumItems = 1;
                numItems = $gameParty.numItems($dataItems[data.materials[1].itemID]);

                data.materials[1].hasNumItems = numItems >= data.materials[1].requireNumItems;
                break;
*/
            // 大きなタル
            case 100:
                data.itemID = 135;

                data.materials = new Array(2);

                // じょうぶな枝 x3
                data.materials[0] = {};

                data.materials[0].itemID = 106;

                data.materials[0].requireNumItems = 3;
                numItems = $gameParty.numItems($dataItems[data.materials[0].itemID]);

                data.materials[0].hasNumItems = numItems >= data.materials[0].requireNumItems;

                // けものの皮 x1
                data.materials[1] = {};

                data.materials[1].itemID = 108;

                data.materials[1].requireNumItems = 1;
                numItems = $gameParty.numItems($dataItems[data.materials[1].itemID]);

                data.materials[1].hasNumItems = numItems >= data.materials[1].requireNumItems;
                break;

            // 生命の薬
            case 110:
                if ($gameParty.numItems($dataItems[149]) == 0)
                {
                    data.itemID = -1;
                    return;
                }

                data.itemID = 5;

                data.materials = new Array(2);

                // マンドラゴラ x1
                data.materials[0] = {};

                data.materials[0].itemID = 114;

                data.materials[0].requireNumItems = 1;
                numItems = $gameParty.numItems($dataItems[data.materials[0].itemID]);

                data.materials[0].hasNumItems = numItems >= data.materials[0].requireNumItems;

                // 魔法の水 x1
                data.materials[1] = {};

                data.materials[1].itemID = 111;

                data.materials[1].requireNumItems = 1;
                numItems = $gameParty.numItems($dataItems[data.materials[1].itemID]);

                data.materials[1].hasNumItems = numItems >= data.materials[1].requireNumItems;
                break;

            // 無敵の薬
            case 120:
                if ($gameParty.numItems($dataItems[150]) == 0)
                {
                    data.itemID = -1;
                    return;
                }

                data.itemID = 7;

                data.materials = new Array(3);

                // マンドラゴラ x1
                data.materials[0] = {};

                data.materials[0].itemID = 114;

                data.materials[0].requireNumItems = 1;
                numItems = $gameParty.numItems($dataItems[data.materials[0].itemID]);

                data.materials[0].hasNumItems = numItems >= data.materials[0].requireNumItems;

                // 人魚の涙 x1
                data.materials[1] = {};

                data.materials[1].itemID = 123;

                data.materials[1].requireNumItems = 1;
                numItems = $gameParty.numItems($dataItems[data.materials[1].itemID]);

                data.materials[1].hasNumItems = numItems >= data.materials[1].requireNumItems;

                // 魔法の水 x1
                data.materials[2] = {};

                data.materials[2].itemID = 111;

                data.materials[2].requireNumItems = 1;
                numItems = $gameParty.numItems($dataItems[data.materials[2].itemID]);

                data.materials[2].hasNumItems = numItems >= data.materials[2].requireNumItems;
                break;
/*
            // 必中の薬
            case 120:
                data.itemID = 8;

                data.materials = new Array(2);

                // 目薬 x1
                data.materials[0] = {};

                data.materials[0].itemID = 209;

                data.materials[0].requireNumItems = 1;
                numItems = $gameParty.numItems($dataItems[data.materials[0].itemID]);

                data.materials[0].hasNumItems = numItems >= data.materials[0].requireNumItems;

                // 魔法の水 x1
                data.materials[1] = {};

                data.materials[1].itemID = 111;

                data.materials[1].requireNumItems = 1;
                numItems = $gameParty.numItems($dataItems[data.materials[1].itemID]);

                data.materials[1].hasNumItems = numItems >= data.materials[1].requireNumItems;
                break;
*/
            // 銅のかたまり
            case 130:
                if ($gameParty.numItems($dataItems[151]) == 0)
                {
                    data.itemID = -1;
                    return;
                }

                data.itemID = 119;

                data.materials = new Array(2);

                // 銅の鉱石 x5
                data.materials[0] = {};

                data.materials[0].itemID = 103;

                data.materials[0].requireNumItems = 5;
                numItems = $gameParty.numItems($dataItems[data.materials[0].itemID]);

                data.materials[0].hasNumItems = numItems >= data.materials[0].requireNumItems;

                // ホットストーン x3
                data.materials[1] = {};

                data.materials[1].itemID = 121;

                data.materials[1].requireNumItems = 3;
                numItems = $gameParty.numItems($dataItems[data.materials[1].itemID]);

                data.materials[1].hasNumItems = numItems >= data.materials[1].requireNumItems;
                break;

            // 鉄のかたまり
            case 140:
                if ($gameParty.numItems($dataItems[152]) == 0)
                {
                    data.itemID = -1;
                    return;
                }

                data.itemID = 120;

                data.materials = new Array(2);

                // 鉄鉱石 x5
                data.materials[0] = {};

                data.materials[0].itemID = 104;

                data.materials[0].requireNumItems = 5;
                numItems = $gameParty.numItems($dataItems[data.materials[0].itemID]);

                data.materials[0].hasNumItems = numItems >= data.materials[0].requireNumItems;

                // ホットストーン x3
                data.materials[1] = {};

                data.materials[1].itemID = 121;

                data.materials[1].requireNumItems = 3;
                numItems = $gameParty.numItems($dataItems[data.materials[1].itemID]);

                data.materials[1].hasNumItems = numItems >= data.materials[1].requireNumItems;
                break;

            // 石炭
            case 150:
                if ($gameParty.numItems($dataItems[153]) == 0)
                {
                    data.itemID = -1;
                    return;
                }

                data.itemID = 122;

                data.materials = new Array(2);

                // じょうぶな枝 5
                data.materials[0] = {};

                data.materials[0].itemID = 106;

                data.materials[0].requireNumItems = 5;
                numItems = $gameParty.numItems($dataItems[data.materials[0].itemID]);

                data.materials[0].hasNumItems = numItems >= data.materials[0].requireNumItems;

                // ホットストーン x3
                data.materials[1] = {};

                data.materials[1].itemID = 121;

                data.materials[1].requireNumItems = 3;
                numItems = $gameParty.numItems($dataItems[data.materials[1].itemID]);

                data.materials[1].hasNumItems = numItems >= data.materials[1].requireNumItems;
                break;

            // 羊皮紙
            case 160:
                if ($gameParty.numItems($dataItems[154]) == 0)
                {
                    data.itemID = -1;
                    return;
                }

                data.itemID = 124;

                data.materials = new Array(2);

                // けものの皮 x1
                data.materials[0] = {};

                data.materials[0].itemID = 108;

                data.materials[0].requireNumItems = 1;
                numItems = $gameParty.numItems($dataItems[data.materials[0].itemID]);

                data.materials[0].hasNumItems = numItems >= data.materials[0].requireNumItems;

                // きれいな水 x1
                data.materials[1] = {};

                data.materials[1].itemID = 101;

                data.materials[1].requireNumItems = 1;
                numItems = $gameParty.numItems($dataItems[data.materials[1].itemID]);

                data.materials[1].hasNumItems = numItems >= data.materials[1].requireNumItems;

                break;

            // 金塊
            case 170:
                if ($gameParty.numItems($dataItems[155]) == 0)
                {
                    data.itemID = -1;
                    return;
                }

                data.itemID = 116;

                data.materials = new Array(1);

                // 黄金のかけら x5
                data.materials[0] = {};

                data.materials[0].itemID = 115;

                data.materials[0].requireNumItems = 5;
                numItems = $gameParty.numItems($dataItems[data.materials[0].itemID]);

                data.materials[0].hasNumItems = numItems >= data.materials[0].requireNumItems;
                break;

            // 睡眠薬
            case 20:
                if ($gameParty.numItems($dataItems[202]) == 0)
                {
                    data.itemID = -1;
                    return;
                }

                data.itemID = 200;

                data.materials = new Array(2);

                // 眠りキノコ x1
                data.materials[0] = {};

                data.materials[0].itemID = 100;

                data.materials[0].requireNumItems = 1;
                numItems = $gameParty.numItems($dataItems[data.materials[0].itemID]);

                data.materials[0].hasNumItems = numItems >= data.materials[0].requireNumItems;

                // きれいな水 x2
                data.materials[1] = {};

                data.materials[1].itemID = 101;

                data.materials[1].requireNumItems = 2;
                numItems = $gameParty.numItems($dataItems[data.materials[1].itemID]);

                data.materials[1].hasNumItems = numItems >= data.materials[1].requireNumItems;
                break;

            // 勃起薬
            case 30:
                if ($gameParty.numItems($dataItems[203]) == 0)
                {
                    data.itemID = -1;
                    return;
                }

                data.itemID = 201;

                data.materials = new Array(3);

                // 火炎草 x2
                data.materials[0] = {};

                data.materials[0].itemID = 109;

                data.materials[0].requireNumItems = 2;
                numItems = $gameParty.numItems($dataItems[data.materials[0].itemID]);

                data.materials[0].hasNumItems = numItems >= data.materials[0].requireNumItems;

                // ミノタウロスの肉 x1
                data.materials[1] = {};

                data.materials[1].itemID = 112;

                data.materials[1].requireNumItems = 1;
                numItems = $gameParty.numItems($dataItems[data.materials[1].itemID]);

                data.materials[1].hasNumItems = numItems >= data.materials[1].requireNumItems;

                // 活力剤 x2
                data.materials[2] = {};

                data.materials[2].itemID = 113;

                data.materials[2].requireNumItems = 2;
                numItems = $gameParty.numItems($dataItems[data.materials[2].itemID]);

                data.materials[2].hasNumItems = numItems >= data.materials[2].requireNumItems;
                break;

            // 催眠薬
            case 40:
                if ($gameParty.numItems($dataItems[206]) == 0)
                {
                    data.itemID = -1;
                    return;
                }

                data.itemID = 204;

                data.materials = new Array(3);

                // 眠りキノコ x2
                data.materials[0] = {};

                data.materials[0].itemID = 100;

                data.materials[0].requireNumItems = 2;
                numItems = $gameParty.numItems($dataItems[data.materials[0].itemID]);

                data.materials[0].hasNumItems = numItems >= data.materials[0].requireNumItems;

                // 氷草 x1
                data.materials[1] = {};

                data.materials[1].itemID = 110;

                data.materials[1].requireNumItems = 1;
                numItems = $gameParty.numItems($dataItems[data.materials[1].itemID]);

                data.materials[1].hasNumItems = numItems >= data.materials[1].requireNumItems;

                // スライムゼリー x2
                data.materials[2] = {};

                data.materials[2].itemID = 107;

                data.materials[2].requireNumItems = 2;
                numItems = $gameParty.numItems($dataItems[data.materials[2].itemID]);

                data.materials[2].hasNumItems = numItems >= data.materials[2].requireNumItems;
                break;

            // 媚薬
            case 50:
                if ($gameParty.numItems($dataItems[207]) == 0)
                {
                    data.itemID = -1;
                    return;
                }

                data.itemID = 205;

                data.materials = new Array(3);

                // マンドラゴラ x1
                data.materials[0] = {};

                data.materials[0].itemID = 114;

                data.materials[0].requireNumItems = 1;
                numItems = $gameParty.numItems($dataItems[data.materials[0].itemID]);

                data.materials[0].hasNumItems = numItems >= data.materials[0].requireNumItems;

                // 金の卵 x1
                data.materials[1] = {};

                data.materials[1].itemID = 118;

                data.materials[1].requireNumItems = 1;
                numItems = $gameParty.numItems($dataItems[data.materials[1].itemID]);

                data.materials[1].hasNumItems = numItems >= data.materials[1].requireNumItems;

                // 魔法の水 x2
                data.materials[2] = {};

                data.materials[2].itemID = 111;

                data.materials[2].requireNumItems = 2;
                numItems = $gameParty.numItems($dataItems[data.materials[2].itemID]);
                data.materials[2].hasNumItems = numItems >= data.materials[2].requireNumItems;
                break;

            // かぜ薬
            case 180:
                if ($gameParty.numItems($dataItems[197]) == 0)
                {
                    data.itemID = -1;
                    return;
                }

                data.itemID = 208;

                data.materials = new Array(3);

                // 火炎草 x3
                data.materials[0] = {};

                data.materials[0].itemID = 109;

                data.materials[0].requireNumItems = 3;
                numItems = $gameParty.numItems($dataItems[data.materials[0].itemID]);

                data.materials[0].hasNumItems = numItems >= data.materials[0].requireNumItems;

                // 活力剤 x1
                data.materials[1] = {};

                data.materials[1].itemID = 113;

                data.materials[1].requireNumItems = 1;
                numItems = $gameParty.numItems($dataItems[data.materials[1].itemID]);

                data.materials[1].hasNumItems = numItems >= data.materials[1].requireNumItems;

                // 魔法の水 x1
                data.materials[2] = {};

                data.materials[2].itemID = 111;

                data.materials[2].requireNumItems = 1;
                numItems = $gameParty.numItems($dataItems[data.materials[2].itemID]);

                data.materials[2].hasNumItems = numItems >= data.materials[2].requireNumItems;
                break;

            // 目薬
            case 190:
                if ($gameParty.numItems($dataItems[198]) == 0)
                {
                    data.itemID = -1;
                    return;
                }

                data.itemID = 209;

                data.materials = new Array(2);

                // きれいな水 x2
                data.materials[0] = {};

                data.materials[0].itemID = 101;

                data.materials[0].requireNumItems = 2;
                numItems = $gameParty.numItems($dataItems[data.materials[0].itemID]);

                data.materials[0].hasNumItems = numItems >= data.materials[0].requireNumItems;

                // 魔法の水 x1
                data.materials[1] = {};

                data.materials[1].itemID = 111;

                data.materials[1].requireNumItems = 1;
                numItems = $gameParty.numItems($dataItems[data.materials[1].itemID]);

                data.materials[1].hasNumItems = numItems >= data.materials[1].requireNumItems;
                break;

            // クリスタル
            case 200:
                if ($gameParty.numItems($dataItems[156]) == 0)
                {
                    data.itemID = -1;
                    return;
                }

                data.itemID = 141;

                data.materials = new Array(2);

                // ホットストーン x5
                data.materials[0] = {};

                data.materials[0].itemID = 121;

                data.materials[0].requireNumItems = 5;
                numItems = $gameParty.numItems($dataItems[data.materials[0].itemID]);

                data.materials[0].hasNumItems = numItems >= data.materials[0].requireNumItems;

                // コールドストーン x5
                data.materials[1] = {};

                data.materials[1].itemID = 139;

                data.materials[1].requireNumItems = 5;
                numItems = $gameParty.numItems($dataItems[data.materials[1].itemID]);

                data.materials[1].hasNumItems = numItems >= data.materials[1].requireNumItems;
                break;
        }

        // 錬金可
        data.canAlchemy = true;
        for (var i = 0; i < data.materials.length; ++i)
        {
            data.canAlchemy = data.canAlchemy && data.materials[i].hasNumItems;
        }
    };

    // 水平線
    AlchemyListWindow.prototype.drawHorzLine = function (y)
    {
        var lineY = y + this.lineHeight() / 2 - 1;
        this.contents.paintOpacity = 48;
        this.contents.fillRect(0, lineY, this.contentsWidth(), 2, this.normalColor());
        this.contents.paintOpacity = 255;
    };

    AlchemyListWindow.prototype.windowHeight = function ()
    {
        return 60 + this.fittingHeight(this.numVisibleRows());
    };

    AlchemyListWindow.prototype.itemRect = function (index)
    {
        var rect = new Rectangle();
        var maxCols = this.maxCols();
        rect.width = this.itemWidth();
        rect.height = this.itemHeight();
        rect.x = index % maxCols * (rect.width + this.spacing()) - this._scrollX;
        rect.y = Math.floor(index / maxCols) * rect.height - this._scrollY;

        rect.y += 60;
        return rect;
    };

    // 全てのアイテムを描画
    AlchemyListWindow.prototype.drawAllItems = function ()
    {
        this.changeTextColor(this.normalColor());
        this.drawText("있는 것", 0, 0, 160, 'left');

        var leftArrow = "‐", rightArrow = "‐";
        if (this._pageIndex > 0)
        {
            leftArrow = "←";
        }
        if (this._pageIndex < this._maxPages - 1)
        {
            rightArrow = "→";
        }

        this.drawText(leftArrow + (this._pageIndex + 1) + "/" + this._maxPages + rightArrow, this._width - this.standardPadding() - 180, 0, 160, 'right');

        this.drawHorzLine(24);

        var topIndex = this.topIndex();
        for (var i = 0; i < this.maxPageItems() ; i++)
        {
            var index = topIndex + i;
            if (index < this._list[this._pageIndex].length)
            {
                this.drawItem(index);
            }
        }
    };

    AlchemyListWindow.prototype.cursorRight = function (wrap)
    {
        var oldIndex = this._pageIndex;

        ++this._pageIndex;
        if (this._pageIndex >= this._maxPages)
        {
            this._pageIndex = 0;
        }

        Window_Command.prototype.cursorRight.call(this, wrap);

        if (oldIndex != this._pageIndex)
        {
            AudioManager.playSe({ "name": "se_cursor01", "volume": 90, "pitch": 100, "pan": 0 })

            this.refresh();
            this._requireWindow.refresh();
        }
    };

    AlchemyListWindow.prototype.cursorLeft = function (wrap)
    {
        var oldIndex = this._pageIndex;

        --this._pageIndex;
        if (this._pageIndex < 0)
        {
            this._pageIndex = this._maxPages - 1;
        }

        Window_Command.prototype.cursorLeft.call(this, wrap);

        if (oldIndex != this._pageIndex)
        {
            AudioManager.playSe({ "name": "se_cursor01", "volume": 90, "pitch": 100, "pan": 0 })

            this.refresh();
            this._requireWindow.refresh();
        }
    };

    // 更新
    AlchemyListWindow.prototype.update = function ()
    {
        var oldIndex = this._index;

        Window_Selectable.prototype.update.call(this);

        if (oldIndex != this._index)
        {
            this._requireWindow.refresh();
        }
    };

    AlchemyListWindow.prototype.refresh = function ()
    {
        this.clearCommandList();
        this.makeCommandList();
        this.height = this.windowHeight();
        this.createContents();
        Window_Selectable.prototype.refresh.call(this);
    };

    //-----------------------------------------------------------------------------
    // AlchemyRequireWindow
    //
    // コンストラクタ
    function AlchemyRequireWindow(listWindow)
    {
        this._listWindow = listWindow;

        this.initialize.apply(this, arguments);
    }

    AlchemyRequireWindow.prototype = Object.create(Window_Base.prototype);
    AlchemyRequireWindow.prototype.constructor = AlchemyRequireWindow;

    // プロパティ定義
    Object.defineProperties(AlchemyRequireWindow.prototype,
    {
        listWindow: { get: function () { return this._listWindow; }, set: function (value) { this._listWindow = value; } },
    });

    // 初期化
    AlchemyRequireWindow.prototype.initialize = function ()
    {
        var x = 340 + 20;
        var y = this._listWindow.y;

        var width = 436;
        var height = 256;

        Window_Base.prototype.initialize.call(this, x, y, width, height);

        this.refresh();
    };

    // 行の高さ
    AlchemyRequireWindow.prototype.lineHeight = function ()
    {
        return this._lineHeight || 36;
    };

    // 水平線
    AlchemyRequireWindow.prototype.drawHorzLine = function (y)
    {
        var lineY = y + this.lineHeight() / 2 - 1;
        this.contents.paintOpacity = 48;
        this.contents.fillRect(0, lineY, this.contentsWidth(), 2, this.normalColor());
        this.contents.paintOpacity = 255;
    };

    // リフレッシュ
    AlchemyRequireWindow.prototype.refresh = function ()
    {
        this.contents.clear();

        var x = 20;
        var y = 0;

        this.resetTextColor();
        this.changePaintOpacity(true);

        this.drawText("필요한 소재", 0, y, 120, 'left');
        this.drawText("필요 수/소지 수", this._width - this.standardPadding() - 180, y, 160, 'right');

        this.drawHorzLine(24);

        y += 24 + this.lineHeight();

        this.drawRequireItem(y, this._listWindow.alchemyList[this._listWindow.index() + (this._listWindow.pageIndex * 10)]);
    };


    // 錬金内容の描画
    AlchemyRequireWindow.prototype.drawRequireItem = function (y, data)
    {
        var leftX = 0;
        var rightX = 320;
        var itemWidthMax = 330;
        var requireWidthMax = 80;

        var itemID;
        var numItems, requireNumItems;

        for (var i = 121; i < 140; ++i)
        {
            $gameVariables.setValue(i, 0);
        }

        for (var i = 0; i < data.materials.length; ++i)
        {
            this.resetTextColor();
            this.changePaintOpacity(data.materials[i].hasNumItems);

            itemID = data.materials[i].itemID;
            requireNumItems = data.materials[i].requireNumItems;

            this.drawText($dataItems[itemID].name, leftX, y, itemWidthMax, 'left');
            this.drawText(requireNumItems + "/" + $gameParty.numItems($dataItems[itemID]), rightX, y, requireWidthMax, 'right');

            $gameVariables.setValue(121 + (i * 2), itemID);
            $gameVariables.setValue(122 + (i * 2), requireNumItems);

            y += this.lineHeight();
        }
    };

    //-----------------------------------------------------------------------------
    // Scene_Alchemy
    //
    function Scene_Alchemy()
    {
        this.initialize.apply(this, arguments);
    }

    Scene_Alchemy.prototype = Object.create(Scene_MenuBase.prototype);
    Scene_Alchemy.prototype.constructor = Scene_Alchemy;

    // 作成
    Scene_Alchemy.prototype.create = function ()
    {
        Scene_MenuBase.prototype.create.call(this);
        this.createAlchemyListWindow();
        this.createAlchemyRequireWindow();
    };

    // 錬金ウィンドウの作成
    Scene_Alchemy.prototype.createAlchemyListWindow = function ()
    {
        this._alchemyListWindow = new AlchemyListWindow();
        this._alchemyListWindow.setHandler('ok', this.chooseAlchemy.bind(this));
        this._alchemyListWindow.setHandler('cancel', this.cancelAlchemy.bind(this));
        this.addWindow(this._alchemyListWindow);
    };

    // 錬金要求素材ウィンドウの作成
    Scene_Alchemy.prototype.createAlchemyRequireWindow = function ()
    {
        this._alchemyRequireWindow = new AlchemyRequireWindow(this._alchemyListWindow);
        this.addWindow(this._alchemyRequireWindow);

        this._alchemyListWindow.requireWindow = this._alchemyRequireWindow;
    };

    // アイテムを選択する
    Scene_Alchemy.prototype.chooseAlchemy = function ()
    {
        SoundManager.playOk();

        var data = this._alchemyListWindow.alchemyList[this._alchemyListWindow.index() + (this._alchemyListWindow.pageIndex * 10)];

        $gameVariables.setValue(9, this._alchemyListWindow._pageIndex);
        $gameVariables.setValue(8, this._alchemyListWindow.index());

        $gameVariables.setValue(2, data.itemID);

        $gameVariables.setValue(3, $dataItems[data.itemID].name);

        this.popScene();
    };

    // キャンセル
    Scene_Alchemy.prototype.cancelAlchemy = function ()
    {
        SoundManager.playCancel();

        $gameVariables.setValue(9, 0);
        $gameVariables.setValue(8, 0);

        $gameVariables.setValue(2, 0);

        this.popScene();
    };
})();
